<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for custodianstbl
 */
class Custodianstbl extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Export
    public $ExportDoc;

    // Fields
    public $id;
    public $Lastname;
    public $Firstname;
    public $User_id;
    public $Cadre;
    public $MDA_id;
    public $Location_id;
    public $Gender;
    public $Created_on;
    public $Updated_on;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'custodianstbl';
        $this->TableName = 'custodianstbl';
        $this->TableType = 'TABLE';

        // Update Table
        $this->UpdateTable = "`custodianstbl`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // id
        $this->id = new DbField('custodianstbl', 'custodianstbl', 'x_id', 'id', '`id`', '`id`', 21, 20, -1, false, '`id`', false, false, false, 'FORMATTED TEXT', 'NO');
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Sortable = true; // Allow sort
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->id->Param, "CustomMsg");
        $this->Fields['id'] = &$this->id;

        // Lastname
        $this->Lastname = new DbField('custodianstbl', 'custodianstbl', 'x_Lastname', 'Lastname', '`Lastname`', '`Lastname`', 200, 191, -1, false, '`Lastname`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Lastname->Nullable = false; // NOT NULL field
        $this->Lastname->Required = true; // Required field
        $this->Lastname->Sortable = true; // Allow sort
        $this->Lastname->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Lastname->Param, "CustomMsg");
        $this->Fields['Lastname'] = &$this->Lastname;

        // Firstname
        $this->Firstname = new DbField('custodianstbl', 'custodianstbl', 'x_Firstname', 'Firstname', '`Firstname`', '`Firstname`', 200, 191, -1, false, '`Firstname`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Firstname->Nullable = false; // NOT NULL field
        $this->Firstname->Required = true; // Required field
        $this->Firstname->Sortable = true; // Allow sort
        $this->Firstname->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Firstname->Param, "CustomMsg");
        $this->Fields['Firstname'] = &$this->Firstname;

        // User_id
        $this->User_id = new DbField('custodianstbl', 'custodianstbl', 'x_User_id', 'User_id', '`User_id`', '`User_id`', 3, 100, -1, false, '`User_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->User_id->Sortable = true; // Allow sort
        $this->User_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->User_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->User_id->Lookup = new Lookup('User_id', 'reportuserstbl', true, 'userid', ["Username","","",""], [], [], [], [], [], [], '`Username`', '');
                break;
            default:
                $this->User_id->Lookup = new Lookup('User_id', 'reportuserstbl', true, 'userid', ["Username","","",""], [], [], [], [], [], [], '`Username`', '');
                break;
        }
        $this->User_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->User_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->User_id->Param, "CustomMsg");
        $this->Fields['User_id'] = &$this->User_id;

        // Cadre
        $this->Cadre = new DbField('custodianstbl', 'custodianstbl', 'x_Cadre', 'Cadre', '`Cadre`', '`Cadre`', 200, 191, -1, false, '`Cadre`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Cadre->Nullable = false; // NOT NULL field
        $this->Cadre->Required = true; // Required field
        $this->Cadre->Sortable = true; // Allow sort
        $this->Cadre->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Cadre->Param, "CustomMsg");
        $this->Fields['Cadre'] = &$this->Cadre;

        // MDA_id
        $this->MDA_id = new DbField('custodianstbl', 'custodianstbl', 'x_MDA_id', 'MDA_id', '`MDA_id`', '`MDA_id`', 3, 100, -1, false, '`MDA_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->MDA_id->Nullable = false; // NOT NULL field
        $this->MDA_id->Required = true; // Required field
        $this->MDA_id->Sortable = true; // Allow sort
        $this->MDA_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->MDA_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA","","",""], [], ["x_Location_id"], [], [], [], [], '`MDA`', '<span class="text-info">{{:df1}}</span> <small class="text-muted">({{:df2}})</small>');
                break;
            default:
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA","","",""], [], ["x_Location_id"], [], [], [], [], '`MDA`', '<span class="text-info">{{:df1}}</span> <small class="text-muted">({{:df2}})</small>');
                break;
        }
        $this->MDA_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MDA_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_id->Param, "CustomMsg");
        $this->Fields['MDA_id'] = &$this->MDA_id;

        // Location_id
        $this->Location_id = new DbField('custodianstbl', 'custodianstbl', 'x_Location_id', 'Location_id', '`Location_id`', '`Location_id`', 3, 100, -1, false, '`Location_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Location_id->Nullable = false; // NOT NULL field
        $this->Location_id->Required = true; // Required field
        $this->Location_id->Sortable = true; // Allow sort
        $this->Location_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Location_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Location_id->Lookup = new Lookup('Location_id', 'locationtbl', true, 'Locationid', ["Location","","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Location`', '');
                break;
            default:
                $this->Location_id->Lookup = new Lookup('Location_id', 'locationtbl', true, 'Locationid', ["Location","","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Location`', '');
                break;
        }
        $this->Location_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Location_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Location_id->Param, "CustomMsg");
        $this->Fields['Location_id'] = &$this->Location_id;

        // Gender
        $this->Gender = new DbField('custodianstbl', 'custodianstbl', 'x_Gender', 'Gender', '`Gender`', '`Gender`', 200, 191, -1, false, '`Gender`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Gender->Nullable = false; // NOT NULL field
        $this->Gender->Required = true; // Required field
        $this->Gender->Sortable = true; // Allow sort
        $this->Gender->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Gender->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Gender->Lookup = new Lookup('Gender', 'custodianstbl', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->Gender->Lookup = new Lookup('Gender', 'custodianstbl', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->Gender->OptionCount = 2;
        $this->Gender->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Gender->Param, "CustomMsg");
        $this->Fields['Gender'] = &$this->Gender;

        // Created_on
        $this->Created_on = new DbField('custodianstbl', 'custodianstbl', 'x_Created_on', 'Created_on', '`Created_on`', CastDateFieldForLike("`Created_on`", 0, "DB"), 133, 10, 0, false, '`Created_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_on->Sortable = true; // Allow sort
        $this->Created_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Created_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_on->Param, "CustomMsg");
        $this->Fields['Created_on'] = &$this->Created_on;

        // Updated_on
        $this->Updated_on = new DbField('custodianstbl', 'custodianstbl', 'x_Updated_on', 'Updated_on', '`Updated_on`', CastDateFieldForLike("`Updated_on`", 0, "DB"), 133, 10, 0, false, '`Updated_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Updated_on->Sortable = true; // Allow sort
        $this->Updated_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Updated_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Updated_on->Param, "CustomMsg");
        $this->Fields['Updated_on'] = &$this->Updated_on;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`custodianstbl`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            $filter = $this->addUserIDFilter($filter);
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
            // Get insert id if necessary
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->Lastname->DbValue = $row['Lastname'];
        $this->Firstname->DbValue = $row['Firstname'];
        $this->User_id->DbValue = $row['User_id'];
        $this->Cadre->DbValue = $row['Cadre'];
        $this->MDA_id->DbValue = $row['MDA_id'];
        $this->Location_id->DbValue = $row['Location_id'];
        $this->Gender->DbValue = $row['Gender'];
        $this->Created_on->DbValue = $row['Created_on'];
        $this->Updated_on->DbValue = $row['Updated_on'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = $this->id->OldValue !== null ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("custodianstbllist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "custodianstblview") {
            return $Language->phrase("View");
        } elseif ($pageName == "custodianstbledit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "custodianstbladd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "CustodianstblView";
            case Config("API_ADD_ACTION"):
                return "CustodianstblAdd";
            case Config("API_EDIT_ACTION"):
                return "CustodianstblEdit";
            case Config("API_DELETE_ACTION"):
                return "CustodianstblDelete";
            case Config("API_LIST_ACTION"):
                return "CustodianstblList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "custodianstbllist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("custodianstblview", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("custodianstblview", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "custodianstbladd?" . $this->getUrlParm($parm);
        } else {
            $url = "custodianstbladd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("custodianstbledit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("custodianstbladd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("custodianstbldelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->Lastname->setDbValue($row['Lastname']);
        $this->Firstname->setDbValue($row['Firstname']);
        $this->User_id->setDbValue($row['User_id']);
        $this->Cadre->setDbValue($row['Cadre']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->Location_id->setDbValue($row['Location_id']);
        $this->Gender->setDbValue($row['Gender']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->Updated_on->setDbValue($row['Updated_on']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // Lastname

        // Firstname

        // User_id

        // Cadre

        // MDA_id

        // Location_id

        // Gender

        // Created_on

        // Updated_on

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewCustomAttributes = "";

        // Lastname
        $this->Lastname->ViewValue = $this->Lastname->CurrentValue;
        $this->Lastname->ViewCustomAttributes = "";

        // Firstname
        $this->Firstname->ViewValue = $this->Firstname->CurrentValue;
        $this->Firstname->ViewCustomAttributes = "";

        // User_id
        $curVal = trim(strval($this->User_id->CurrentValue));
        if ($curVal != "") {
            $this->User_id->ViewValue = $this->User_id->lookupCacheOption($curVal);
            if ($this->User_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`userid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->User_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->User_id->Lookup->renderViewRow($rswrk[0]);
                    $this->User_id->ViewValue = $this->User_id->displayValue($arwrk);
                } else {
                    $this->User_id->ViewValue = $this->User_id->CurrentValue;
                }
            }
        } else {
            $this->User_id->ViewValue = null;
        }
        $this->User_id->ViewCustomAttributes = "";

        // Cadre
        $this->Cadre->ViewValue = $this->Cadre->CurrentValue;
        $this->Cadre->ViewCustomAttributes = "";

        // MDA_id
        $curVal = trim(strval($this->MDA_id->CurrentValue));
        if ($curVal != "") {
            $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
            if ($this->MDA_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                    $this->MDA_id->ViewValue = $this->MDA_id->displayValue($arwrk);
                } else {
                    $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
                }
            }
        } else {
            $this->MDA_id->ViewValue = null;
        }
        $this->MDA_id->ViewCustomAttributes = "";

        // Location_id
        $curVal = trim(strval($this->Location_id->CurrentValue));
        if ($curVal != "") {
            $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
            if ($this->Location_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                    $this->Location_id->ViewValue = $this->Location_id->displayValue($arwrk);
                } else {
                    $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
                }
            }
        } else {
            $this->Location_id->ViewValue = null;
        }
        $this->Location_id->ViewCustomAttributes = "";

        // Gender
        if (strval($this->Gender->CurrentValue) != "") {
            $this->Gender->ViewValue = $this->Gender->optionCaption($this->Gender->CurrentValue);
        } else {
            $this->Gender->ViewValue = null;
        }
        $this->Gender->ViewCustomAttributes = "";

        // Created_on
        $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
        $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
        $this->Created_on->ViewCustomAttributes = "";

        // Updated_on
        $this->Updated_on->ViewValue = $this->Updated_on->CurrentValue;
        $this->Updated_on->ViewValue = FormatDateTime($this->Updated_on->ViewValue, 0);
        $this->Updated_on->ViewCustomAttributes = "";

        // id
        $this->id->LinkCustomAttributes = "";
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // Lastname
        $this->Lastname->LinkCustomAttributes = "";
        $this->Lastname->HrefValue = "";
        $this->Lastname->TooltipValue = "";

        // Firstname
        $this->Firstname->LinkCustomAttributes = "";
        $this->Firstname->HrefValue = "";
        $this->Firstname->TooltipValue = "";

        // User_id
        $this->User_id->LinkCustomAttributes = "";
        $this->User_id->HrefValue = "";
        $this->User_id->TooltipValue = "";

        // Cadre
        $this->Cadre->LinkCustomAttributes = "";
        $this->Cadre->HrefValue = "";
        $this->Cadre->TooltipValue = "";

        // MDA_id
        $this->MDA_id->LinkCustomAttributes = "";
        $this->MDA_id->HrefValue = "";
        $this->MDA_id->TooltipValue = "";

        // Location_id
        $this->Location_id->LinkCustomAttributes = "";
        $this->Location_id->HrefValue = "";
        $this->Location_id->TooltipValue = "";

        // Gender
        $this->Gender->LinkCustomAttributes = "";
        $this->Gender->HrefValue = "";
        $this->Gender->TooltipValue = "";

        // Created_on
        $this->Created_on->LinkCustomAttributes = "";
        $this->Created_on->HrefValue = "";
        $this->Created_on->TooltipValue = "";

        // Updated_on
        $this->Updated_on->LinkCustomAttributes = "";
        $this->Updated_on->HrefValue = "";
        $this->Updated_on->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->EditAttrs["class"] = "form-control";
        $this->id->EditCustomAttributes = "";
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->ViewCustomAttributes = "";

        // Lastname
        $this->Lastname->EditAttrs["class"] = "form-control";
        $this->Lastname->EditCustomAttributes = "";
        if (!$this->Lastname->Raw) {
            $this->Lastname->CurrentValue = HtmlDecode($this->Lastname->CurrentValue);
        }
        $this->Lastname->EditValue = $this->Lastname->CurrentValue;
        $this->Lastname->PlaceHolder = RemoveHtml($this->Lastname->caption());

        // Firstname
        $this->Firstname->EditAttrs["class"] = "form-control";
        $this->Firstname->EditCustomAttributes = "";
        if (!$this->Firstname->Raw) {
            $this->Firstname->CurrentValue = HtmlDecode($this->Firstname->CurrentValue);
        }
        $this->Firstname->EditValue = $this->Firstname->CurrentValue;
        $this->Firstname->PlaceHolder = RemoveHtml($this->Firstname->caption());

        // User_id
        $this->User_id->EditAttrs["class"] = "form-control";
        $this->User_id->EditCustomAttributes = "";
        $this->User_id->PlaceHolder = RemoveHtml($this->User_id->caption());

        // Cadre
        $this->Cadre->EditAttrs["class"] = "form-control";
        $this->Cadre->EditCustomAttributes = "";
        if (!$this->Cadre->Raw) {
            $this->Cadre->CurrentValue = HtmlDecode($this->Cadre->CurrentValue);
        }
        $this->Cadre->EditValue = $this->Cadre->CurrentValue;
        $this->Cadre->PlaceHolder = RemoveHtml($this->Cadre->caption());

        // MDA_id
        $this->MDA_id->EditAttrs["class"] = "form-control";
        $this->MDA_id->EditCustomAttributes = "";
        if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("info")) { // Non system admin
            $this->MDA_id->CurrentValue = CurrentUserID();
            $curVal = trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->EditValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->EditValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->EditValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->EditValue = null;
            }
            $this->MDA_id->ViewCustomAttributes = "";
        } else {
            $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
        }

        // Location_id
        $this->Location_id->EditAttrs["class"] = "form-control";
        $this->Location_id->EditCustomAttributes = "";
        $this->Location_id->PlaceHolder = RemoveHtml($this->Location_id->caption());

        // Gender
        $this->Gender->EditAttrs["class"] = "form-control";
        $this->Gender->EditCustomAttributes = "";
        $this->Gender->EditValue = $this->Gender->options(true);
        $this->Gender->PlaceHolder = RemoveHtml($this->Gender->caption());

        // Created_on

        // Updated_on

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Lastname);
                    $doc->exportCaption($this->Firstname);
                    $doc->exportCaption($this->User_id);
                    $doc->exportCaption($this->Cadre);
                    $doc->exportCaption($this->MDA_id);
                    $doc->exportCaption($this->Location_id);
                    $doc->exportCaption($this->Gender);
                    $doc->exportCaption($this->Created_on);
                    $doc->exportCaption($this->Updated_on);
                } else {
                    $doc->exportCaption($this->Lastname);
                    $doc->exportCaption($this->Firstname);
                    $doc->exportCaption($this->User_id);
                    $doc->exportCaption($this->Cadre);
                    $doc->exportCaption($this->Location_id);
                    $doc->exportCaption($this->Gender);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Lastname);
                        $doc->exportField($this->Firstname);
                        $doc->exportField($this->User_id);
                        $doc->exportField($this->Cadre);
                        $doc->exportField($this->MDA_id);
                        $doc->exportField($this->Location_id);
                        $doc->exportField($this->Gender);
                        $doc->exportField($this->Created_on);
                        $doc->exportField($this->Updated_on);
                    } else {
                        $doc->exportField($this->Lastname);
                        $doc->exportField($this->Firstname);
                        $doc->exportField($this->User_id);
                        $doc->exportField($this->Cadre);
                        $doc->exportField($this->Location_id);
                        $doc->exportField($this->Gender);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Add User ID filter
    public function addUserIDFilter($filter = "")
    {
        global $Security;
        $filterWrk = "";
        $id = (CurrentPageID() == "list") ? $this->CurrentAction : CurrentPageID();
        if (!$this->userIDAllow($id) && !$Security->isAdmin()) {
            $filterWrk = $Security->userIdList();
            if ($filterWrk != "") {
                $filterWrk = '`MDA_id` IN (' . $filterWrk . ')';
            }
        }

        // Call User ID Filtering event
        $this->userIdFiltering($filterWrk);
        AddFilter($filter, $filterWrk);
        return $filter;
    }

    // User ID subquery
    public function getUserIDSubquery(&$fld, &$masterfld)
    {
        global $UserTable;
        $wrk = "";
        $sql = "SELECT " . $masterfld->Expression . " FROM `custodianstbl`";
        $filter = $this->addUserIDFilter("");
        if ($filter != "") {
            $sql .= " WHERE " . $filter;
        }

        // List all values
        if ($rs = Conn($UserTable->Dbid)->executeQuery($sql)->fetchAll(\PDO::FETCH_NUM)) {
            foreach ($rs as $row) {
                if ($wrk != "") {
                    $wrk .= ",";
                }
                $wrk .= QuotedValue($row[0], $masterfld->DataType, Config("USER_TABLE_DBID"));
            }
        }
        if ($wrk != "") {
            $wrk = $fld->Expression . " IN (" . $wrk . ")";
        } else { // No User ID value found
            $wrk = "0=1";
        }
        return $wrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Write Audit Trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        $table = 'custodianstbl';
        $usr = CurrentUserID();
        WriteAuditLog($usr, $typ, $table, "", "", "", "");
    }

    // Write Audit Trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }
        $table = 'custodianstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write Audit Trail
        $usr = CurrentUserID();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") {
                    $newvalue = $Language->phrase("PasswordMask"); // Password Field
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) {
                    if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                        $newvalue = $rs[$fldname];
                    } else {
                        $newvalue = "[MEMO]"; // Memo Field
                    }
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) {
                    $newvalue = "[XML]"; // XML Field
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", $table, $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write Audit Trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }
        $table = 'custodianstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write Audit Trail
        $usr = CurrentUserID();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
                        if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                            $oldvalue = $rsold[$fldname];
                            $newvalue = $rsnew[$fldname];
                        } else {
                            $oldvalue = "[MEMO]";
                            $newvalue = "[MEMO]";
                        }
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write Audit Trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }
        $table = 'custodianstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write Audit Trail
        $curUser = CurrentUserID();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") {
                    $oldvalue = $Language->phrase("PasswordMask"); // Password Field
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) {
                    if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                        $oldvalue = $rs[$fldname];
                    } else {
                        $oldvalue = "[MEMO]"; // Memo field
                    }
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) {
                    $oldvalue = "[XML]"; // XML field
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($curUser, "D", $table, $fldname, $key, $oldvalue, "");
            }
        }
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
